function [outI1,outI2,outA1,outA2] = scaleAugment(I1,I2,A1,A2,shearStdDev)
    [rows, cols, channels] = size(I1);
    sx = normrnd(0,shearStdDev);
    sy = normrnd(0,shearStdDev);
    tform = affine2d([ 1 sy 0; sx 1 0; 0 0 1]);
    view = affineOutputView(size(I1),tform,'BoundsStyle','CenterOutput');
    outI1 = imwarp(I1, tform, 'FillValue', 255, 'OutputView',view);
    outI2 = imwarp(I2, tform, 'FillValue', 255, 'OutputView',view);
    
    % apply transform to annotations
    outA1 = affineAnnotations(A1, tform);
    outA2 = affineAnnotations(A2, tform);
end
